// Dance Classes Website - Version 4 (HTML/CSS/JS)

const danceStyles = [
  { 
    id: 'hiphop', 
    name: 'Хип-хоп', 
    icon: 'icons/style-hiphop.svg',
    color: '#6C5CE7',
    description: 'Энергичный уличный танец',
    duration: '12 занятий',
    level: 'Любой уровень'
  },
  { 
    id: 'bachata', 
    name: 'Бачата', 
    icon: 'icons/style-bachata.svg',
    color: '#A29BFE',
    description: 'Страстный латиноамериканский танец',
    duration: '10 занятий',
    level: 'Начинающий'
  },
  { 
    id: 'zumba', 
    name: 'Зумба', 
    icon: 'icons/style-zumba.svg',
    color: '#FD79A8',
    description: 'Фитнес-танец для всех',
    duration: '8 занятий',
    level: 'Любой уровень'
  },
  { 
    id: 'ballroom', 
    name: 'Бальные', 
    icon: 'icons/style-ballroom.svg',
    color: '#6C5CE7',
    description: 'Классические бальные танцы',
    duration: '16 занятий',
    level: 'Продвинутый'
  }
]

const instructors = [
  { name: 'Алексей Воронов', experience: '10 лет', rating: 5, specialty: 'Хип-хоп, Брейк-данс', students: '3000+' },
  { name: 'Мария Соколова', experience: '12 лет', rating: 5, specialty: 'Бачата, Сальса', students: '4500+' },
  { name: 'Елена Петрова', experience: '8 лет', rating: 5, specialty: 'Зумба, Фитнес', students: '6000+' },
  { name: 'Дмитрий Кузнецов', experience: '15 лет', rating: 5, specialty: 'Бальные, Латина', students: '2500+' }
]

const guarantees = [
  { icon: 'icons/guarantee-quality.svg', title: 'Качество', text: 'Профессиональные преподаватели с многолетним опытом' },
  { icon: 'icons/guarantee-schedule.svg', title: 'График', text: 'Гибкое расписание занятий' },
  { icon: 'icons/guarantee-support.svg', title: 'Поддержка', text: 'Персональный подход к каждому ученику' },
  { icon: 'icons/guarantee-certificate.svg', title: 'Сертификат', text: 'Официальный сертификат по окончании' }
]

let currentSlide = 0
let slides = []
let dots = []
let slideInterval

function initPage() {
  const currentPage = window.location.pathname.includes('enroll.html') ? 'enroll' : 'index'
  
  if (currentPage === 'enroll') {
    initEnrollPage()
  } else {
    initIndexPage()
  }
  
  initSlider()
}

function initIndexPage() {
  loadClasses()
  updateStats()
  
  setInterval(() => {
    loadClasses()
    updateStats()
  }, 500)
}

function loadClasses() {
  const saved = localStorage.getItem('danceClasses')
  let classes = []
  
  if (saved) {
    try {
      classes = JSON.parse(saved)
    } catch (e) {
      classes = []
    }
  } else {
    classes = [
      {
        id: 1,
        style: 'Хип-хоп',
        instructor: 'Алексей Воронов',
        date: '2025-03-28',
        rating: 5
      },
      {
        id: 2,
        style: 'Бачата',
        instructor: 'Мария Соколова',
        date: '2025-03-26',
        rating: 5
      },
      {
        id: 3,
        style: 'Зумба',
        instructor: 'Елена Петрова',
        date: '2025-03-24',
        rating: 4
      }
    ]
    localStorage.setItem('danceClasses', JSON.stringify(classes))
  }
  
  const classesList = document.getElementById('classesList')
  if (classesList) {
    if (classes.length === 0) {
      classesList.innerHTML = `
        <div class="empty-state">
          <h3 class="empty-title">Нет занятий</h3>
          <p class="empty-text">Запишитесь на занятие прямо сейчас</p>
        </div>
      `
    } else {
      classesList.innerHTML = classes.map(classItem => {
        const stars = Array.from({ length: 5 }, (_, i) => 
          `<span class="star">${i < classItem.rating ? '★' : '☆'}</span>`
        ).join('')
        
        const date = new Date(classItem.date).toLocaleDateString('ru-RU', { 
          day: 'numeric', 
          month: 'long', 
          year: 'numeric' 
        })
        
        return `
          <div class="class-item">
            <div class="class-main">
              <div class="class-info">
                <h3 class="class-style">${classItem.style}</h3>
                <div class="class-details">
                  <div class="class-detail">
                    <img src="icons/class-instructor.svg" alt="Instructor" width="18" height="18">
                    <span>${classItem.instructor}</span>
                  </div>
                  <div class="class-detail">
                    <img src="icons/class-date.svg" alt="Date" width="18" height="18">
                    <span>${date}</span>
                  </div>
                </div>
              </div>
              <div class="class-rating">${stars}</div>
            </div>
          </div>
        `
      }).join('')
    }
  }
}

function updateStats() {
  const saved = localStorage.getItem('danceClasses')
  let classes = []
  
  if (saved) {
    try {
      classes = JSON.parse(saved)
    } catch (e) {
      classes = []
    }
  }
  
  const totalClasses = classes.length
  const uniqueInstructors = new Set(classes.map(c => c.instructor)).size
  const averageRating = classes.length > 0 
    ? (classes.reduce((sum, c) => sum + c.rating, 0) / classes.length).toFixed(1)
    : 0
  
  const stats = [
    {
      value: totalClasses,
      label: 'Занятий',
      icon: 'icons/stat-classes.svg',
      color: 'rgba(108, 92, 231, 0.15)'
    },
    {
      value: averageRating,
      label: 'Средняя оценка',
      icon: 'icons/stat-rating.svg',
      color: 'rgba(162, 155, 254, 0.15)'
    },
    {
      value: uniqueInstructors,
      label: 'Преподавателей',
      icon: 'icons/stat-instructors.svg',
      color: 'rgba(253, 121, 168, 0.15)'
    }
  ]
  
  const statsGrid = document.getElementById('statsGrid')
  if (statsGrid) {
    statsGrid.innerHTML = stats.map(stat => `
      <div class="stat-card">
        <div class="stat-icon-wrapper" style="background: ${stat.color};">
          <img src="${stat.icon}" alt="" width="40" height="40">
        </div>
        <div class="stat-content">
          <div class="stat-value">${stat.value}</div>
          <div class="stat-label">${stat.label}</div>
        </div>
      </div>
    `).join('')
  }
}

function initEnrollPage() {
  const enrollmentForm = document.getElementById('enrollmentForm')
  const stylesList = document.getElementById('stylesList')
  const dateInput = document.getElementById('startDate')
  const successMessage = document.getElementById('successMessage')
  const guaranteesGrid = document.getElementById('guaranteesGrid')
  const instructorsGrid = document.getElementById('instructorsGrid')

  let selectedStyle = null

  if (stylesList) {
    stylesList.innerHTML = danceStyles.map(style => `
      <button type="button" class="style-item" data-id="${style.id}">
        <div class="style-icon">
          <img src="${style.icon}" alt="${style.name}" width="32" height="32">
        </div>
        <div class="style-content">
          <h3 class="style-name">${style.name}</h3>
          <p class="style-description">${style.description}</p>
          <div class="style-meta">
            <span class="style-duration">
              <img src="icons/benefit-clock.svg" alt="Clock" width="16" height="16">
              ${style.duration}
            </span>
            <span class="style-level">${style.level}</span>
          </div>
        </div>
        <div class="style-check" style="display: none;">
          <img src="icons/btn-check.svg" alt="Check" width="24" height="24">
        </div>
      </button>
    `).join('')

    stylesList.querySelectorAll('.style-item').forEach(item => {
      item.addEventListener('click', () => {
        stylesList.querySelectorAll('.style-item').forEach(i => {
          i.classList.remove('selected')
          i.querySelector('.style-check').style.display = 'none'
        })
        item.classList.add('selected')
        item.querySelector('.style-check').style.display = 'block'
        selectedStyle = item.dataset.id
        
        const submitBtn = document.getElementById('submitBtn')
        if (submitBtn) {
          submitBtn.disabled = !selectedStyle || !dateInput.value
        }
      })
    })
  }

  if (dateInput) {
    const today = new Date()
    const maxDate = new Date()
    maxDate.setMonth(maxDate.getMonth() + 6)
    
    dateInput.min = today.toISOString().split('T')[0]
    dateInput.max = maxDate.toISOString().split('T')[0]
    
    dateInput.addEventListener('change', () => {
      const submitBtn = document.getElementById('submitBtn')
      if (submitBtn) {
        submitBtn.disabled = !selectedStyle || !dateInput.value
      }
    })
  }

  if (enrollmentForm) {
    enrollmentForm.addEventListener('submit', (e) => {
      e.preventDefault()
      
      if (selectedStyle && dateInput && dateInput.value) {
        const savedClasses = localStorage.getItem('danceClasses')
        const classes = savedClasses ? JSON.parse(savedClasses) : []
        
        const styleData = danceStyles.find(s => s.id === selectedStyle)
        const randomInstructor = instructors[Math.floor(Math.random() * instructors.length)]
        
        const newClass = {
          id: Date.now(),
          style: styleData.name,
          instructor: randomInstructor.name,
          date: dateInput.value,
          rating: 0
        }

        classes.push(newClass)
        localStorage.setItem('danceClasses', JSON.stringify(classes))
        
        if (successMessage) {
          successMessage.style.display = 'flex'
          setTimeout(() => {
            window.location.href = 'index.html'
          }, 2000)
        }
      }
    })
  }

  if (guaranteesGrid) {
    guaranteesGrid.innerHTML = guarantees.map(guarantee => `
      <div class="guarantee-item">
        <div class="guarantee-icon">
          <img src="${guarantee.icon}" alt="${guarantee.title}" width="32" height="32">
        </div>
        <h3 class="guarantee-title">${guarantee.title}</h3>
        <p class="guarantee-text">${guarantee.text}</p>
      </div>
    `).join('')
  }

  if (instructorsGrid) {
    instructorsGrid.innerHTML = instructors.map(instructor => {
      const stars = Array.from({ length: 5 }, () => '★').join('')
      return `
        <div class="instructor-card">
          <div class="instructor-avatar">
            <img src="icons/instructor-avatar.svg" alt="${instructor.name}" width="32" height="32">
          </div>
          <h3 class="instructor-name">${instructor.name}</h3>
          <p class="instructor-experience">${instructor.experience} опыта</p>
          <div class="instructor-rating">
            <span class="star">${stars}</span>
          </div>
          <p class="instructor-specialty">${instructor.specialty}</p>
          <div class="instructor-students">
            <img src="icons/benefit-users.svg" alt="Users" width="16" height="16">
            <span>${instructor.students} учеников</span>
          </div>
        </div>
      `
    }).join('')
  }
}

function initSlider() {
  const slider = document.getElementById('slider')
  if (!slider) return

  slides = Array.from(slider.querySelectorAll('.slide'))
  dots = Array.from(slider.querySelectorAll('.dot'))
  const prevBtn = document.getElementById('sliderPrev')
  const nextBtn = document.getElementById('sliderNext')

  if (slides.length === 0) return

  function showSlide(n) {
    slides.forEach(slide => slide.classList.remove('active'))
    dots.forEach(dot => dot.classList.remove('active'))
    
    currentSlide = (n + slides.length) % slides.length
    
    slides[currentSlide].classList.add('active')
    if (dots[currentSlide]) dots[currentSlide].classList.add('active')
  }

  function nextSlide() {
    showSlide(currentSlide + 1)
  }

  function prevSlide() {
    showSlide(currentSlide - 1)
  }

  if (nextBtn) {
    nextBtn.addEventListener('click', () => {
      clearInterval(slideInterval)
      nextSlide()
      startSlider()
    })
  }

  if (prevBtn) {
    prevBtn.addEventListener('click', () => {
      clearInterval(slideInterval)
      prevSlide()
      startSlider()
    })
  }

  dots.forEach((dot, index) => {
    dot.addEventListener('click', () => {
      clearInterval(slideInterval)
      showSlide(index)
      startSlider()
    })
  })

  function startSlider() {
    slideInterval = setInterval(nextSlide, 3000)
  }

  showSlide(0)
  startSlider()
}

document.addEventListener('DOMContentLoaded', initPage)

